%function [Hint,Rxx_Dn,Rxx_Up,Rxy_Dn,Rxy_Up] = Field_Interp(Sample,H)
% Seperate temperature sweeps at varying field strengths, and plot and
% interpolated sweep up and down.

%Filenames and directories
    SavePath = strcat('/',num2str(H,'%.2f'),'T/');
    MakeDirectory(SavePath);
    GraphSavePath = strcat('/',num2str(H,'%.2f'),'T');
    MakeDirectory(GraphSavePath);

%File details
    delimiterIn = ' ';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end

%Open the datafiles
    FilterSpec = '.dat';
    
    DialogTitle = 'Select file with magnetic field sweep data';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);

%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
    
    Data(:,1) = Data(:,1)/10000;
    %Data(:,Rcol) = -Data(:,Rcol);
    
%Split data into columns

    Hcol = Data(:,1);
    Rcol = Data(:,2);
    Tcol = Data(:,3);
    
%Split into up and down sweeps.

    n = size(Data,1);
    j = 1;
    k = 1;
    
    
    for i = 2:n-1
        if (Tcol(i+1) - Tcol(i)) < 0.005 
           Data_Up(j,1) = Hcol(i);
           Data_Up(j,2) = Rcol(i);
           Data_Up(j,3) = Tcol(i);
           j = j + 1;          
        else
           
        end
    end
    
    for i = 2:n-1
        if (Tcol(i+1) - Tcol(i)) > 0.005 
           Data_Down(k,1) = Hcol(i);
           Data_Down(k,2) = Rcol(i);
           Data_Down(k,3) = Tcol(i);
           k = k + 1;
        else
        end
    end

    TitleStr = strcat(Sample,' {}',num2str(H,'%.2f'),' {}T');
    
    %plot of raw data
    figure; hold on;
    plot(Data_Up(:,3),Data_Up(:,2),'r','linewidth',1.5);
    plot(Data_Down(:,3),Data_Down(:,2),'b','linewidth',1.5);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it Temperature (K)','fontsize',20,'fontname','times');
    ylabel('\it Resistance (\Omega)','fontsize',20,'fontname','times');
    box on;
    title(strcat(TitleStr,' {}Raw data'));
    Legend = cell(2,1);
    Legend{1} = strcat('Sweep Up');
    Legend{2} = strcat('Sweep Down');
    legend(Legend, 'location', 'NorthWest');
    set(legend,'FontSize',20);
    legend show Location NorthWest
    legend boxoff
    %savefilename = strcat(GraphSavePath,'RawData_',num2str(H,'%.2f'),'T.png');
    %[output] = FileOverWriteCheck(savefilename);
    %saveas(gcf,savefilename);
    %if(output == 1); export_fig(savefilename); end
    %savefilename = strcat(GraphSavePath,'RawData_',num2str(H,'%.2f'),'T.fig');
    %[output] = FileOverWriteCheck(savefilename);
    %if(output == 1); saveas(gcf,savefilename); end
    hold off

    %Save data into files
    FileName = strcat(SavePath,Sample,'_',num2str(H,'%.2f'),'_Sweep_Up.dat');
    [output] = FileOverWriteCheck(FileName);
    if(output == 1); dlmwrite(FileName,[Data_Up]); end

    FileName = strcat(SavePath,Sample,'_',num2str(H,'%.2f'),'_Sweep_Down.dat');
    [output] = FileOverWriteCheck(FileName);
    if(output == 1); dlmwrite(FileName,[Data_Down]); end



%end

